/*  This Stata code replicates the empirical results presented in:
Anzia, Sarah F. 2011. "Election Timing and the Electoral Influence of 
Interest Groups." Journal of Politics 73 (2): 412-427. 
April 25, 2011  */

* Load 9-state SASS data
use "nine_state_SASS_5_5_11.dta", clear

* Number of school districts with on/off-cycle elections, in SASS, by state:
tab stabbr offcycleprim if charters_pc<=.5 & stabbr~="IN"

* These regressions produce columns (1), (3), and (5) of table 1.

* Table 1, column (1)
xi: reg lnbach_noexp offcycleprim lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & stabbr~="IN", cluster(STATE) 

* Table 1, column (3)
xi: reg lnmast_10yrs offcycleprim lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & stabbr~="IN", cluster(STATE)  

* Table 1, column (5)
xi: reg lnhighest_step offcycleprim lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5& stabbr~="IN", cluster(STATE) 

* For dollar figures on page 418 (multiply by .038 and .042, respectively):
 tabstat mast_10yrs if offcycleprim==0, by(stabbr)
 tabstat highest_step if offcycleprim==0, by(stabbr)
 
* State fixed effects alone; described on page 419
xi: reg lnbach_noexp offcycleprim ///
 i.STATE if charters_pc<=.5 & stabbr~="IN", cluster(STATE)
xi: reg lnmast_10yrs offcycleprim ///
 i.STATE if charters_pc<=.5 & stabbr~="IN", cluster(STATE)
xi: reg lnhighest_step offcycleprim ///
 i.STATE if charters_pc<=.5 & stabbr~="IN", cluster(STATE)	


* Table 1, column (2)
xi: reg lnbach_noexp offcycleprim nea_teacher lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & stabbr~="IN" & nea_teacher<=2, cluster(STATE) 

* Table 1, column (4)
xi: reg lnmast_10yrs offcycleprim nea_teacher lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & stabbr~="IN" & nea_teacher<=2, cluster(STATE) 

* Table 1, column (6)
xi: reg lnhighest_step offcycleprim nea_teacher lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5& stabbr~="IN" & nea_teacher<=2, cluster(STATE)


* Load Minnesota data

use "minnesota_5_5_11.dta", clear

* Table 2, column (1)
xi: reg lntchravgsalary offyear lnstudents ///
lnmedinc staterev_pc city rural town ///
hispanic_pc black_pc api_pc ami_pc avgyrsexp ///
newteach if lntchravgsalary>10.06, cluster(countyfips)

* Table 2, column (2)
xi: reg lntchravgsalary offyear dempres_2pty lnstudents ///
lnmedinc staterev_pc city rural town ///
hispanic_pc black_pc api_pc ami_pc avgyrsexp newteach ///
if lntchravgsalary>10.06, cluster(countyfips)

* Table 2, column (3) 
xi: reg lntchravgsalary turnout turnout_sq lnstudents ///
lnmedinc staterev_pc city rural town ///
hispanic_pc black_pc api_pc ami_pc avgyrsexp newteach ///
if lntchravgsalary>10.06 & turnout!=0, cluster(countyfips)

* For Figure 2: Use turnout as % and 
xi: reg lntchravgsalary turnout_pc turnout_pc_sq lnstudents ///
lnmedinc staterev_pc city rural town ///
hispanic_pc black_pc api_pc ami_pc avgyrsexp newteach ///
if lntchravgsalary>10.06 & turnout!=0, cluster(countyfips)
* Get covariance matrix
estat vce
* Medians of all variables
tabstat lnstudents lnmedinc staterev_pc city rural town ///
hispanic_pc black_pc api_pc ami_pc avgyrsexp newteach ///
if lntchravgsalary>10.06 & turnout!=0, ///
stat(median)

* Table 2, column (4)
xi: reg lnsuptavgsalary offyear lnstudents  ///
lnmedinc staterev_pc city rural town ///
hispanic_pc black_pc api_pc ami_pc avgyrsexp newteach ///
if lntchravgsalary>10.06, cluster(countyfips)

* Table 2, column (5)
xi: reg lnsuptavgsalary turnout turnout_sq lnstudents  ///
lnmedinc staterev_pc city rural town ///
hispanic_pc black_pc api_pc ami_pc avgyrsexp newteach ///
if lntchravgsalary>10.06 & turnout!=0, cluster(countyfips)


/* The following code replicates the results from the online
data appendix. */

* Load SASS 9-state data

use "nine_state_SASS_5_5_11.dta", clear

* Table A1, columns (1)-(3)

xi: reg lnbach_noexp offcycleprim ///
 i.STATE if charters_pc<=.5 & stabbr~="IN", cluster(STATE)
xi: reg lnmast_10yrs offcycleprim ///
 i.STATE if charters_pc<=.5 & stabbr~="IN", cluster(STATE)
xi: reg lnhighest_step offcycleprim ///
 i.STATE if charters_pc<=.5 & stabbr~="IN", cluster(STATE)	
	
* Table A2, columns (1)-(3)
* Results including the 3 districts with charter schools > .5

xi: reg lnbach_noexp offcycleprim lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if stabbr~="IN", cluster(STATE) 

xi: reg lnmast_10yrs offcycleprim lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if stabbr~="IN", cluster(STATE) 
 
xi: reg lnhighest_step offcycleprim lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if stabbr~="IN", cluster(STATE) 

* Table A3:  By region and type of election timing variation

xi: reg lnbach_noexp offcycleprim lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & vartype==0, cluster(STATE)
	
 xi: reg lnbach_noexp offcycleprim lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & vartype==1, cluster(STATE)
 
xi: reg lnhighest_step offcycleprim lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & vartype==0, cluster(STATE)
 
 xi: reg lnhighest_step offcycleprim lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & vartype==1, cluster(STATE)

xi: reg lnbach_noexp offcycleprim lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & south==0 & stabbr~="IN", cluster(STATE)
	
 xi: reg lnbach_noexp offcycleprim lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & south==1, cluster(STATE)
 
xi: reg lnhighest_step offcycleprim lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & south==0 & stabbr~="IN", cluster(STATE)
 
 xi: reg lnhighest_step offcycleprim lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & south==1, cluster(STATE)
	
* Table A4:  Full country models

* Load full country data	
use "full_country_SASS_5_5_11.dta", clear
	
xi: xtreg lnbach_noexp offcycleprim lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 if charters_pc<=.5 & disttype<4, fe cluster(STATE) 

xi: xtreg lnmast_10yrs offcycleprim lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 if charters_pc<=.5 & disttype<4, fe cluster(STATE) 

xi: xtreg lnhighest_step offcycleprim lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 if charters_pc<=.5 & disttype<4, fe cluster(STATE) 
		
* Table A5: Categorizing primary elections as off-cycle rather than on-cycle

* Load 9-state SASS data

use "nine_state_SASS_5_5_11.dta", clear

xi: reg lnbach_noexp offcycle lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & stabbr~="TN", cluster(STATE) 
	
xi: reg lnbach_noexp oncycle fedprimcons lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5, cluster(STATE) 

test oncycle=fedprimcons
 
xi: reg lnmast_10yrs offcycle lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & stabbr~="TN", cluster(STATE) 

xi: reg lnmast_10yrs oncycle fedprimcons lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5, cluster(STATE) 

test oncycle=fedprimcons
	
xi: reg lnhighest_step offcycle lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & stabbr~="TN", cluster(STATE) 
	
xi: reg lnhighest_step oncycle fedprimcons lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5, cluster(STATE) 

test oncycle=fedprimcons

* Table A6:  Controlling for 2004 county vote for Kerry

xi: reg lnbach_noexp i.offcycleprim kerry_pc lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & stabbr~="IN", cluster(STATE) 
 
xi: reg lnmast_10yrs i.offcycleprim kerry_pc lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & stabbr~="IN", cluster(STATE) 

xi: reg lnhighest_step i.offcycleprim kerry_pc lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5& stabbr~="IN", cluster(STATE) 


* Table A7:  NEA ratio, log NEA, interaction term

xi: reg lnbach_noexp offcycleprim c_nea_teacher lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & stabbr~="IN", cluster(STATE)
  
xi: reg lnhighest_step offcycleprim c_nea_teacher lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & stabbr~="IN", cluster(STATE)

* Log NEA instead of NEA ratio

xi: reg lnbach_noexp offcycleprim lnnea lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & stabbr~="IN", cluster(STATE)
  
xi: reg lnhighest_step offcycleprim lnnea lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & stabbr~="IN", cluster(STATE)

* Interaction between NEA ratio and off-cycle

xi: reg lnbach_noexp i.offcycleprim*c_nea_teacher lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5 & stabbr~="IN" & nea_teacher<=2, cluster(STATE) 

xi: reg lnhighest_step i.offcycleprim*c_nea_teacher lnenrollment lnmedinc ///
city fringe ///
hispanic_pc black_pc-amindian_pc staterev_pc ///
 i.STATE if charters_pc<=.5& stabbr~="IN" & nea_teacher<=2, cluster(STATE) 

* Load Minnesota data

use "minnesota_5_5_11.dta", clear

* Table A8:  

* NEA-to-teacher ratio
xi: reg lntchravgsalary offyear nea_teacher lnstudents ///
lnmedinc staterev_pc city rural town ///
hispanic_pc black_pc api_pc ami_pc avgyrsexp newteach if lntchravgsalary>10.06, cluster(countyfips)

* with 2004 Kerry vote share by county, not by district
xi: reg lntchravgsalary offyear kerry_pc lnstudents ///
lnmedinc staterev_pc city rural town ///
hispanic_pc black_pc api_pc ami_pc avgyrsexp newteach if lntchravgsalary>10.06, cluster(countyfips)
	
* with off-year referendum indicator
xi: reg lntchravgsalary offyear ref_oddyear lnstudents ///
lnmedinc staterev_pc city rural town ///
hispanic_pc black_pc api_pc ami_pc avgyrsexp newteach if lntchravgsalary>10.06, cluster(countyfips)

* using the log of turnout rather than turnout and its square
xi: reg lntchravgsalary lnturnout lnstudents ///
lnmedinc staterev_pc city rural town ///
hispanic_pc black_pc api_pc ami_pc avgyrsexp newteach if lntchravgsalary>10.06 & turnout!=0, cluster(countyfips)

* Average admin salary
xi: reg ln_avgadminsalary offyear lnstudents ///
lnmedinc staterev_pc city rural town ///
hispanic_pc black_pc api_pc ami_pc avgyrsexp newteach if lntchravgsalary>10.06, cluster(countyfips)

xi: reg ln_avgadminsalary turnout turnout_sq lnstudents ///
lnmedinc staterev_pc city rural town ///
hispanic_pc black_pc api_pc ami_pc avgyrsexp newteach if lntchravgsalary>10.06 & turnout~=0, cluster(countyfips)
